<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest;

use Twilio\Domain;
use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Rest\Video\V1;
use Twilio\Rest\Video\V1\CompositionContext;
use Twilio\Rest\Video\V1\CompositionHookContext;
use Twilio\Rest\Video\V1\CompositionHookList;
use Twilio\Rest\Video\V1\CompositionList;
use Twilio\Rest\Video\V1\CompositionSettingsContext;
use Twilio\Rest\Video\V1\CompositionSettingsList;
use Twilio\Rest\Video\V1\RecordingContext;
use Twilio\Rest\Video\V1\RecordingList;
use Twilio\Rest\Video\V1\RecordingSettingsContext;
use Twilio\Rest\Video\V1\RecordingSettingsList;
use Twilio\Rest\Video\V1\RoomContext;
use Twilio\Rest\Video\V1\RoomList;
use Twilio\Version;

/**
 * @property V1 v1
 * @property CompositionHookList compositionHooks
 * @property CompositionSettingsList compositionSettings
 * @property RecordingList recordings
 * @property RecordingSettingsList recordingSettings
 * @property CompositionList compositions
 * @property RoomList rooms
 * @method CompositionHookContext compositionHooks(string $sid)
 * @method CompositionSettingsContext compositionSettings()
 * @method RecordingContext recordings(string $sid)
 * @method RecordingSettingsContext recordingSettings()
 * @method CompositionContext compositions(string $sid)
 * @method RoomContext rooms(string $sid)
 */
class Video extends Domain {
    protected $_v1 = null;

    /**
     * Construct the Video Domain
     * 
     * @param Client $client Twilio\Rest\Client to communicate with
     *                                    Twilio
     * @return Video Domain for Video
     */
    public function __construct(Client $client) {
        parent::__construct($client);

        $this->baseUrl = 'https://video.twilio.com';
    }

    /**
     * Magic getter to lazy load version
     *
     * @param string $name Version to return
     *
     * @return Version The requested version
     * @throws TwilioException For unknown versions
     */
    public function __get($name) {
        $method = 'get' . ucfirst($name);
        if (method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown version ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     *
     * @return InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call($name, $arguments) {
        $method = 'context' . ucfirst($name);
        if (method_exists($this, $method)) {
            return call_user_func_array(array($this, $method), $arguments);
        }

        throw new TwilioException('Unknown context ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        return '[Twilio.Video]';
    }

    /**
     * @return V1 Version v1 of video
     */
    protected function getV1() {
        if (!$this->_v1) {
            $this->_v1 = new V1($this);
        }
        return $this->_v1;
    }

    /**
     * @return CompositionHookList
     */
    protected function getCompositionHooks() {
        return $this->v1->compositionHooks;
    }

    /**
     * @param string $sid The Composition Hook Sid that uniquely identifies the
     *                    Composition Hook to fetch.
     * @return CompositionHookContext
     */
    protected function contextCompositionHooks($sid) {
        return $this->v1->compositionHooks($sid);
    }

    /**
     * @return CompositionSettingsList
     */
    protected function getCompositionSettings() {
        return $this->v1->compositionSettings;
    }

    /**
     * @return CompositionSettingsContext
     */
    protected function contextCompositionSettings() {
        return $this->v1->compositionSettings();
    }

    /**
     * @return RecordingList
     */
    protected function getRecordings() {
        return $this->v1->recordings;
    }

    /**
     * @param string $sid The Recording Sid that uniquely identifies the Recording
     *                    to fetch.
     * @return RecordingContext
     */
    protected function contextRecordings($sid) {
        return $this->v1->recordings($sid);
    }

    /**
     * @return RecordingSettingsList
     */
    protected function getRecordingSettings() {
        return $this->v1->recordingSettings;
    }

    /**
     * @return RecordingSettingsContext
     */
    protected function contextRecordingSettings() {
        return $this->v1->recordingSettings();
    }

    /**
     * @return CompositionList
     */
    protected function getCompositions() {
        return $this->v1->compositions;
    }

    /**
     * @param string $sid The Composition Sid that uniquely identifies the
     *                    Composition to fetch.
     * @return CompositionContext
     */
    protected function contextCompositions($sid) {
        return $this->v1->compositions($sid);
    }

    /**
     * @return RoomList
     */
    protected function getRooms() {
        return $this->v1->rooms;
    }

    /**
     * @param string $sid The Room Sid or name that uniquely identifies this
     *                    resource.
     * @return RoomContext
     */
    protected function contextRooms($sid) {
        return $this->v1->rooms($sid);
    }
}