<?php
/*
 * Class Name : GFHANNANSMS_Pro_{strtoupper( php file name) }
 */
class GFHANNANSMS_Pro_SATSMS {

	/*
	* Gateway title
	*/
	public static function name($gateways) {
		$name = __('سات اس ام اس', 'GF_SMS' );
		$gateway = array( strtolower( str_replace( 'GFHANNANSMS_Pro_', '', get_called_class())) => $name );
		return array_unique( array_merge( $gateways , $gateway ) );
	}

	/*
	* Gateway parameters
	*/
	public static function options() {
		return array(
			'username' => __('نام کاربری','GF_SMS'),
			'password' => __('پسورد','GF_SMS')
		);
	}

	/*
	* Gateway credit
	*/
	public static function credit() {
		return true;
	}

	/*
	* Gateway action
	*/
	public static function process( $options, $action, $from, $to, $messages ) {
		if ( $action == 'credit' && !self::credit() ) {
			return false;
		} elseif ( ! extension_loaded('soap') ) {
			return __('ماژول Soap بر روی هاست شما فعال نمی باشد .','GF_SMS');
		} elseif ($action == "send") {
			try	{
				$to = explode(',', $to);
				$i = sizeOf($to);
				while($i--) {
					$uNumber = Trim($to[$i]);
					$ret = &$uNumber;
					if (substr($uNumber,0, 5) == '%2B98') {
						$ret = substr($uNumber, 5);
					}
					if (substr($uNumber,0, 5) == '%2b98') {
						$ret = substr($uNumber, 5);
					}
					if (substr($uNumber,0, 4) == '0098') {
						$ret = substr($uNumber, 4);
					}
					if (substr($uNumber,0, 3) == '098') {
						$ret = substr($uNumber, 3);
					}
					if (substr($uNumber,0, 3) == '+98') {
						$ret = substr($uNumber, 3);
					}
					if (substr($uNumber,0, 2) == '98') {
						$ret = substr($uNumber, 2);
					}
					$to[$i] = '0' . $ret;
				}
				if (!is_string($messages)) {
					$messages = json_encode($messages);
				}
				$recId = array(0);
				$status = 0x0;
				ini_set("soap.wsdl_cache_enabled", "0");
				$client = new SoapClient("http://payamakapi.ir/SendService.svc?wsdl", array('encoding'=>'UTF-8'));
				$send = $client->SendSms($parameters = array(
						'userName'       => $options['username'],
						'password'       => $options['password'],
						'fromNumber'     => $from,
						'toNumbers'      => $to,
						'messageContent' => $messages,
						'isFlash'        => false,
						'recId'          => $recId,
						'status'         => $status
					));
				if ( $send->SendSmsResult == 10 ) {
					return __('وب سرویس غیرفعال است .', 'GF_SMS' );
				} elseif ( $send->SendSmsResult == 9 ) {
					return __('سامانه در حال بروز رسانی است .', 'GF_SMS' );
				} elseif ( $send->SendSmsResult == 8 ) {
					return __('اعتبار کافی نیست .', 'GF_SMS' );
				} elseif ( $send->SendSmsResult == 7 ) {
					return __('متن حاوی کلمات فیلتر شده میباشد .', 'GF_SMS' );
				} elseif ( $send->SendSmsResult == 6 ) {
					return __('خط فرسنتده غیرفعال است .', 'GF_SMS' );
				} elseif ( $send->SendSmsResult == 5 ) {
					return __('محدودیت در حجم ارسال .', 'GF_SMS' );
				} elseif ( $send->SendSmsResult == 4 ) {
					return __('محدودیت در ارسال روزانه .', 'GF_SMS' );
				} elseif ( $send->SendSmsResult == 3 ) {
					return __('شماره فرستنده معتبر نیست .', 'GF_SMS' );
				} elseif ( $send->SendSmsResult == 2 ) {
					return __('کاربر مورد نظر فعال نیست .', 'GF_SMS' );
				} elseif ( $send->SendSmsResult == 1 ) {
					return __('نام کاربری یا کلمه عبور اشتباه است .', 'GF_SMS' );
				} elseif ( $send->SendSmsResult == 0 ) {
					return 'OK';
				} else {
					return __('خطای ناشناخته .', 'GF_SMS' );
				}
			}
			catch (exception $ex) {
				return $ex->getMessage();
			}
		} elseif ($action == "credit") {
			try	{
				ini_set("soap.wsdl_cache_enabled", "0");
				$client = new SoapClient("http://payamakapi.ir/SendService.svc?wsdl", array('encoding'=>'UTF-8'));
				$credit = $client->GetCredit($parameters = array(
						'userName'       => $options['username'],
						'password'       => $options['password'],
					));
				if ( $credit->GetCreditResult == -2 ) {
					return __('کاربر مورد نظر فعال نیست .', 'GF_SMS' );
				} elseif ( $credit->GetCreditResult == -1 ) {
					return __('نام کاربری یا کلمه عبور اشتباه است .', 'GF_SMS' );
				} else {
					return ( (int) $credit->GetCreditResult ) . __(' پیامک', 'GF_SMS' );
				}
			}
			catch (exception $ex) {
				return $ex->getMessage();
			}
		} elseif ($action == "range") {
			$min = 100;
			$max = 200;
			return array("min" => $min, "max" => $max);
		}
	}

}